//
//  B5DataOperationCommon.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-07-13.
//
//

#import <Foundation/Foundation.h>

@class OPItem;

FOUNDATION_EXPORT NSString *B5DocumentDataExtension;
FOUNDATION_EXPORT NSString *B5DocumentAttributesExtension;
FOUNDATION_EXPORT NSString *B5IconDataExtension;
FOUNDATION_EXPORT NSString *B5IconAttributesExtension;
FOUNDATION_EXPORT NSString *B5DocumentUploadResponseExtension;
FOUNDATION_EXPORT NSString *B5IconUploadResponseExtension;
FOUNDATION_EXPORT NSString *B5IconQueuedPrefix;

@interface B5DataOperationCommon : NSObject

// Downloaded files
+ (NSURL *)downloadedResourceURLForAccountUUID:(NSString *)accountUUID profileUUID:(NSString *)profileUUID file:(NSString *)fileName;

// File Pending Uploads
+ (NSURL *)pendingUploadFileURLForAccountUUID:(NSString *)accountUUID profileUUID:(NSString *)profileUUID file:(NSString *)fileName;

// Generate a file name for a item that is pending upload
+ (NSString *)fileNameForPendingUploadForItem:(OPItem *)item prefix:(NSString *)prefix extension:(NSString *)extension;

// Where a file would be if it was ready for upload (no queued, not downloaded)
+ (NSURL *)fileURLForCommittedFileOfExtension:(NSString *)extension forItem:(OPItem *)item;

// Returns a fileURL for the item, if the regular committed file exists it returns a URL with a Queued prefix
+ (NSURL *)fileURLForToSaveCustomIconFileOfExtension:(NSString *)extension forItem:(OPItem *)item;

// Return a URL for a pending upload that is a known existing file
+ (NSURL *)validURLForPendingExistingIconForItem:(OPItem *)item extension:(NSString *)extension;

@end
